<?
/***********************************************************************************
* SCRIPT       : Xihuitl Calendar
* VERSION      : 1.0
* AUTHOR       : Ezequiel Alans Gzz.
* EMAIL        : chequelonmx@yahoo.com.mx
* WEBSITE      : http://www.ealanis.com
* DATE         : 04/13/2003
* COUNTRY      : Mxico
* COPYRIGHT    : This software is provided AS IS.
                 The author can not be held liable for any damage
                 that might arise from the use of this software.
                 Use it at your own risk.
                 All copyright notices and links to Author's website
                 MUST remain intact in the scripts and in the HTML
                 for the scripts.
* DESCRIPTION  : Calendar, Contacts and Notes
* COMMENTS     : Simple to set-up and to configure/adjust it
***********************************************************************************/
include("db.inc");
include("calendar.php");
include("appointments.php");
?>

<html>
<head>
<title>Xihuitl Calendar</title>
<link href="img/dynCal.css" rel="stylesheet">
</head>
<body topmargin="0" leftmargin="0">
<table width='100%' border='0' cellspacing='0' cellpadding='0'>
<tr>
<td width='50%' align='left'><img src='img/logo.gif' border='0' alt='Xihuitl Calendar'/></td>
<td width='50%' align='right'><img src='img/calendar.gif' border='0' alt='Aztec Calendar' /></td>
</tr>
</table>

<?php

$av["o"] = "";
$av["ts"] = time();

if(count($HTTP_POST_VARS)>0) {
  while(list($key,$val) = each($HTTP_POST_VARS)) {
    $av[$key] = $val;
  }
}
elseif(count($HTTP_GET_VARS)>0) {
  while(list($key,$val) = each($HTTP_GET_VARS)) {
    $av[$key] = $val;
  }
}

// modificaciones a la db appointments y se guarda en una cadena
// para mostrarla en su lugar correcto
$html = "";
switch($av["o"]) {
  case "aa": // form add appointment
    $html .= formAppt($av["ts"],"","","sa","F",$av["ti"],1,0,"N","0-0-0",0,0);
    break;

  case "sa": // save appointment
    if($av["cboRuMo"] . "-" . $av["cboRuDa"] . "-" . $av["txtRuYr"] == "0-0-"
    || $av["radRepeat"] == "N") {
      // No End
      $html .= addAppt($av["txtName"],$av["radAllDay"],$av["cboStartTime"],
        $av["cboDurationHrs"],$av["cboDurationMins"],
        $av["txtMsg"], $av["radRepeat"],
        "9999-12-31",$av["radIcon"], $av["ts"]);
      $html .= showAppts($av["ts"]);
    }// validamos la fecha de "Repeticin Hasta"
    else {
      if(checkdate($av["cboRuMo"],$av["cboRuDa"],$av["txtRuYr"])) {
        $html .= addAppt($av["txtName"],$av["radAllDay"],$av["cboStartTime"],
          $av["cboDurationHrs"],$av["cboDurationMins"],
          $av["txtMsg"], $av["radRepeat"],
          $av["txtRuYr"] . "-" . $av["cboRuMo"] . "-" . $av["txtRuDa"],
          $av["radIcon"], $av["ts"]);
        $html .= showAppts($av["ts"]);
      }
      else { // Mostramos el error y reimprimimos la forma
        $html .= msg("a","The Repeat End Date is not valid");
        $html .= formAppt($av["ts"],$av["txtName"],$av["txtMsg"],
          "sa",$av["radAllDay"],$av["cboStartTime"],
          $av["cboDurationHrs"],$av["cboDurationMins"],
          $av["radRepeat"],"0-0-0",$av["radIcon"],0);
      }
    }
    break;

  case "ea": // form edit appointment
    $html .= editAppt($av["a"],$av["ts"]);
    break;

  case "ua": // update appointment
    // validamos la fecha de "Repeticin Hasta"
    if($av["cboRuMo"] . "-" . $av["cboRuDa"] . "-" . $av["txtRuYr"] == "0-0-"
    || $av["radRepeat"] == "N") {
      $html .= updAppt($av["txtName"],$av["radAllDay"],$av["cboStartTime"],
        $av["cboDurationHrs"],$av["cboDurationMins"],
        $av["txtMsg"], $av["radRepeat"],
        "9999-12-31",$av["radIcon"], $av["a"], $av["ts"]);
      $html .= showAppts($av["ts"]);
    }
    else {
      if(checkdate($av["cboRuMo"],$av["cboRuDa"],$av["txtRuYr"])) {
        $html .= updAppt($av["txtName"],$av["radAllDay"],$av["cboStartTime"],
          $av["cboDurationHrs"],$av["cboDurationMins"],
          $av["txtMsg"], $av["radRepeat"],
          $av["txtRuYr"] . "-" . $av["cboRuMo"] . "-" . $av["cboRuDa"],
          $av["radIcon"], $av["a"], $av["ts"]);
        $html .= showAppts($av["ts"]);
      } // Mostramos el error y reimprimimos la forma
      else {
        $html .= msg("a","The Repeat End Date is not valid");
        $html .= formAppt($av["ts"],$av["txtName"],$av["txtMsg"],
          "ua",$av["radAllDay"],$av["cboStartTime"],
          $av["cboDurationHrs"],$av["cboDurationMins"],
          $av["radRepeat"],"0-0-0",$av["radIcon"],$av["a"]);
      }
    }
    break;

  case "d1": // confirm delete
    $html .= delConfirm($av["a"],$av["ts"]);
    break;

  case "d2": // delete
    $html .= delAppt($av["a"],$av["ts"]);
    $html .= showAppts($av["ts"]);
    break;

  default: // week days
    $html .= showAppts($av["ts"]);
}

// Tabla general de la pgina
echo "<table border='0' cellspacing='0' cellpadding='0' width='532'>";
echo "<tr><td width='200' valign='top'>";

// Dibujado del calendario para el da seleccionado
drawCalendar($av["ts"]);

echo "<br>";

// De Contacts.php
echo bdaysOfMonth(date("n",$av["ts"]));
// Continuacin para tabla de Appointments for the day
echo "</td><td valign='top'>";

echo $html;

// Continuacin con Cumpleaos del mes
echo "</td></tr></table>";
?>
<br />
<a href='http://www.ealanis.com' target='_top'>&copy; Ezequiel Alans, Mxico 2003</a>
</body>
</html>
