<?php

// return spaces, dashes and single quotes to strings
function decodeEntry( $str )
{
   $str = str_replace( "&nbsp;"," ",  $str );
	$str = str_replace(  "&ndash;","-", $str );
	$str = str_replace(  "&quot;","'", $str );
	$str = stripslashes( $str );
	$str = trim( $str );
	
	return $str;
}

// specify filename in which the user's preferences are stored
session_register( 'usersDir' );
$usersDir = $_SESSION[ 'usersDir' ];
session_register( 'userName' );
$userName = $_SESSION[ 'userName' ];
session_register( 'tasksFileName' );
$tasksFileName = $_SESSION[ 'tasksFileName' ];
$tasksFile = "$usersDir/$userName/$tasksFileName";
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Personal Diary - Tasks</title>
<link rel="stylesheet" type="text/css" href="PD.css">

<script type="text/javascript" language="JavaScript">
<!-- hide script from older browsers

var numItemsChecked = 0;

function cBox_onclick( cBox )
{
   if( cBox.checked == true )
	{
	   ++numItemsChecked;
	}
	
	else
	{
	   --numItemsChecked;
	}
	
	return true;
}

function add_onclick( )
{
   // if change was made, confirm user entered a password
   if( document.tasksForm.newTask.value == "" )
	{
	   return false;
	}

   else
	{
   document.tasksForm.action = "PD_saveTasks.php";
		
		return true;
	}

}

function del_onclick( )
{
   document.tasksForm.action = "PD_delTasks.php";
	
	return true;
}

function edit_onclick( )
{
   var itemChecked;
	
   if( numItemsChecked > 0 )
	{
	   document.tasksForm.action = "PD_editTasks.php";
	   
		return true;
	}
	
	else
	{
	   return false;
	}
}

function imgReset( button, newImage )
{
   button.src = newImage;

   return true;
}

//  end hiding comment-->
</script>
</head>

<body bgcolor="#DCE9B1">
<form action="" method="post" name="tasksForm" id="tasksForm">
<table bgcolor="#FFFFCC" width="100%" height="100%" cellspacing="0" cellpadding="0" border="1" align="center">
  <tr>
    <td height="10">
	   &nbsp;
    </td>
    <td colspan="2" align="left">
      <span class="large"><strong>&nbsp;Task List</strong></span>
    </td>
  </tr>
  <tr>
    <td valign="middle" height="88" width="8%" align="center">
      <button class="btn-yellow" type="submit" name="add" width="80" height="32" onClick="add_onclick()">
        <img name="addTask" src="Images/btn_add_up.gif" width="80" height="32" border="0" alt="Add task entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_add_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_add_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_add_up.gif' )">
      </button>
    </td>
    <td colspan="2" align="left" valign="top" height="10">
      <textarea cols="76" rows="5" name="newTask" id="newTask"></textarea>
    </td>
  </tr>
<?php

// open and lock the file.
$filePointer = fopen( $tasksFile, "r" );
flock( $filePointer, LOCK_EX );

$taskCount = 0;
$minRows = 7;

// retrieve tasks from the task file
while( ! feof( $filePointer ) )
{
   $taskStr = fgets( $filePointer );
	
	if( $taskStr == "" )
	{
	   // last line is blank, skip it
	   break;
	}

// create rows in the table to display tasks
   echo"
  <tr>
    <td height='3' bgcolor='#DCE9B1' colspan='3'></td>
  </tr>
  <tr>
    <td valign='middle' height='20' width='5%' align='center'>
      <input type='checkbox' name='$taskCount' value='cBox' onClick='cBox_onclick( this )';>
    </td>
    <td valign='top' height='50' colspan='2'>$taskStr</td>
  </tr>";
  
   ++$taskCount;
 }

fclose( $filePointer );

// if number of tasks is less than the minimum, add blank rows
for( $index = $taskCount; $index < $minRows; ++$index )
{
echo"
  <tr>
    <td height='3' bgcolor='#DCE9B1' colspan='3'></td>
  </tr>
  <tr>
    <td valign='middle' height='20' width='5%' align='center'>&nbsp;</td>
    <td valign='top' height='50' colspan='2'>&nbsp;</td>
  </tr>";
}
?>
  <tr>
    <td height='3' bgcolor='#DCE9B1' colspan='3'></td>
  </tr>
  <tr>
    <td valign="middle" height="80" width="5%" align="center">
      <button class="btn-yellow" type="submit" name="del" width="80" height="32" onClick="del_onclick( );">
        <img name="delTask" src="Images/btn_delete_up.gif" width="80" height="32" border="0" alt="Delete task entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_delete_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_delete_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_delete_up.gif' )">
      </button>
    </td>
    <td valign="middle" colspan="2">
      <button class="btn-yellow" type="submit" name="del" width="80" height="32" onClick="edit_onclick( );">
        <img name="editTask" src="Images/btn_edit_up.gif" width="80" height="32" border="0" alt="Edit task entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_edit_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_edit_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_edit_up.gif' )">
      </button>
      <font color="blue">&nbsp;Click button to delete or edit checked tasks</font>
    </td>
  </tr>
</table>
</form>
</body>
</html>
